<?php


class AopsConvertkitIntegration extends Aops {

	private static $options = array();

	public static $apiKey = '';

	public static $status = self::STATUS_UNKNOWN;

	public static $apiUrl = 'https://api.convertkit.com/v3/';

	public static $emptyFormArray = array( '0' => 'Please select form...');

	public function __construct() {
		self::$options = self::getOptions();

		self::$status = self::$options['convertkit_status'];
		self::$apiKey = self::$options['convertkit_api_key'];

		/* Check Convertkit API Key when it`s entered */
		add_action( 'admin_init', array( $this, 'checkConvertkitApiKey' ) );

		// added this check to make correct update from earlier plugin versions
		// which don't have this field and PHP notice about empty value may break user login

	}

	public function checkConvertkitApiKey() {


		if (isset($_POST['aops_cu_convertkit_api_key'])) {

			self::log(array(
				'source'	=> 'AopsConvertkitIntegration::checkConvertkitApiKey()',
				'message'	=> 'got the POST["aops_cu_convertkit_api_key"], checking... ',
				'data'		=> $_POST['aops_cu_convertkit_api_key']
			));

			$newConvertkitStatus = self::$status;
			$newConvertkitApiKey = $_POST['aops_cu_convertkit_api_key'];

			if ( is_string( $newConvertkitApiKey ) ) {

				if ( $newConvertkitApiKey != self::$apiKey ) {

					update_option(self::$prefix . 'convertkit_default_formid', 0);

					$forms = self::getForms( $newConvertkitApiKey );

					// Check if response indicates successful connect to Convertkit
					if ( is_array( $forms ) ) {
						$newConvertkitStatus = self::STATUS_OK;
					}
					else {
						$newConvertkitStatus = self::STATUS_FAIL;
					}
					// clear options cache
					wp_cache_delete ( 'alloptions', 'options' );
				}
			}
			else {
				$newConvertkitStatus = ($newConvertkitApiKey == '') ? self::STATUS_UNKNOWN : self::STATUS_FAIL;
			}

			// wordpress will use this later to save option into DB
			$_POST['aops_cu_convertkit_status'] = $newConvertkitStatus;
		}
	}


	/**
	 * Gets ConvertKit Forms
	 * http://developers.convertkit.com/#list-forms
	 *
	 * @param string $apiKey
	 * @return array or false on fail
	 */
	public static function getForms($apiKey = '') {
		$result = false;

		if ( ! $apiKey ) {
			$apiKey = self::$apiKey;
		}

		$response = AopsCurlHelper::get(
			self::$apiUrl . 'forms',
			array( 'api_key' => $apiKey )
		);

		$response = json_decode($response);

		$forms = self::$emptyFormArray;

		if ( is_object( $response ) && isset( $response->forms ) && is_array( $response->forms ) ) {

			foreach ( $response->forms as $form ) {
				$forms[$form->id] = $form->name;
			}

			$result = $forms;
		}

		update_option(self::$prefix . 'convertkit_form_list', $forms);
		self::$options['convertkit_form_list'] = $forms;

		return $result;
	}


	/**
	 * Gets ConvertKit Tags
	 * http://developers.convertkit.com/#list-tags
	 *
	 * @param string $apiKey
	 * @return array or false on fail
	 */
	public static function getTags($apiKey = '') {
		$result = false;

		if ( ! $apiKey ) {
			$apiKey = self::$apiKey;
		}

		$response = AopsCurlHelper::get(
			self::$apiUrl . 'tags',
			array( 'api_key' => $apiKey )
		);

		$response = json_decode($response);
		//echo( '$response<pre>' . print_r($response, 1) . '</pre>' );die();

		$tags = array();

		if ( is_object( $response ) && isset( $response->tags ) && is_array( $response->tags ) ) {

			foreach ( $response->tags as $tag ) {
				$tags[$tag->id] = $tag->name;
			}

			$result = $tags;
		}

		update_option(self::$prefix . 'convertkit_tag_ids', $tags);
		self::$options['convertkit_tag_ids'] = $tags;

		return $result;
	}

	public static function processSubmission($cuID, $email, $name) {
		if (self::$status == self::STATUS_OK) {

			$formId = self::$options['convertkit_default_formid'];

			$meta = self::getMeta($cuID);

			$subscriber = array(
				"api_key"			=> self::$apiKey,
				"email"				=> $email,
				'first_name'		=> $name
			);

			if ( $meta['convertkit_form_id'] ) {
				$formId = $meta['convertkit_form_id'];
			}

			if ( $meta['convertkit_tag_enabled'] ) {
				self::log('$meta[convertkit_tag_enabled] ON. ' . $meta['convertkit_tag']);


				/**
				 *	If any tags are selected in "CU Settings > Integrations > ConvertKit > Default Tags",
				 *	these should always be assigned to the subscriber in ConvertKit,
				 *	in addition to the CU-specific tag(s) that are defined when editing an individual CU.
				 */

				if ( is_array( self::$options['convertkit_default_tag_ids'] ) ) {
					$defaultTags = self::$options['convertkit_default_tag_ids'];
				}
				else {
					$defaultTags = array();
				}

				self::log($defaultTags);


				if ( is_array( $meta['convertkit_tag_ids'] ) ) {
					// "Custom Tags" field in CU setting is not empty, use it to set default array of tags
					$cuTags = $meta['convertkit_tag_ids'];
				}
				else { // set empty array of CU tags since " Custom Tags" field in CU setting is empty or invalid
					$cuTags	= array();

				}
				self::log($cuTags);

				$subscriber['tags'] = implode(',', array_merge( $defaultTags, $cuTags ) );

			}

			self::addConvertKitSubscriber( $formId, $subscriber );

		}
	}

	public static function addConvertKitSubscriber($formId, $subscriber) {

		$convertkitApiUrl = self::$apiUrl . 'forms/' . intval( $formId ) . '/subscribe';

		self::log('AopsConvertkitIntegration::addConvertKitSubscriber, $convertkitApiUrl = ' . $convertkitApiUrl .'  $formId ' . $formId);
		self::log($subscriber);

		$curl = AopsCurlHelper::post($convertkitApiUrl, $subscriber );
		self::log( json_decode($curl) );
	}

}
?>
